#version 130
#extension GL_EXT_gpu_shader4 : enable
//Voronoi metballs comboMod01.fsh  by   luka712 

//https://www.shadertoy.com/view/Mt3cRS
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// voronoi example from
// https://www.youtube.com/watch?v=l-07BXzNdPw&t=800s


float Circle(vec2 uv, vec2 pos, float r){
 	
    float d = length(uv - pos);
    return r / d;
}


float random(vec2 p)
{
 	return fract(sin(dot(vec2(100.,324.), p)) * 22141.);   
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    // vc - voronoi coords, mc - metaballs coords
    vec2 vc = fragCoord/iResolution.xy;
    vec2 mc = vc - .5;
    vc.x *= iResolution.x/iResolution.y;
    mc.x *= iResolution.x/iResolution.y;
    
    
    // voronoi
    vc *= 9.; 
    vec2 i = floor(vc);
    vec2 gv = fract(vc) - .5;
    
    float minDist = 1.;
    
    for(float y = -1.; y <= 1.; y++)
    {
     	for(float x = -1.; x <= 1.; x++)
        {
            vec2 o = vec2(x,y);
         	vec2 rp = vec2(random(i + o.xy), random(i + o.xy));  
            vec2 p = o + sin(rp * iTime) * .5;
            float d = length(gv - p);
            
            if(d < minDist){
                minDist = d;
            }
        }
    }
    
    vec3 col = vec3(.5,.75,1.5) * minDist;
    
    
    // metaballs
    float r = .05;
    float c = Circle(mc, vec2(sin(iTime * 2.) * .4,  cos(iTime * .4) * .4), r);
    c += Circle(mc, vec2(sin(iTime * .5) * .4, cos(iTime * .7) * .4), r);
    c += Circle(mc, vec2(sin(iTime * .7) * .4, cos(iTime * .8) * .4), r);
    c += Circle(mc, vec2(sin(iTime * .2) * .4, cos(iTime * .3) * .4), r);
    c += Circle(mc, vec2(sin(iTime * .3) * .4, cos(iTime * .4) * .4), r);
    c += Circle(mc, vec2(sin(iTime * .6) * .4, cos(iTime) * .4), r);
    c += Circle(mc, vec2(sin(iTime * .5) * .4, cos(iTime * .2) * .4), r);
  
    

    // Output to screen
    fragColor = vec4(col,1.0) * c * 1.5;
return fragColor; 
}
///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.